--
--Copyright (c) 1995 by Altera Corporation.  All rights reserved.  This text
--contains proprietary, confidential information of Altera Corporation, and
--may be used, copied, and/or disclosed only pursuant to the terms of a
--valid software license agreement with Altera Corporation.  This copyringht
--notice must be retained as part of this text at all times.
--
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
-- pragma translate_off
use std.textio.all;
-- pragma translate_on
entity syn_ram_256x8_iror is
     --pragma translate_off
     generic ( LPM_FILE : string := "UNUSED" );
     --pragma translate_on
     port (  Data     : in std_logic_vector(7 downto 0);
             Address  : in std_logic_vector(7 downto 0);
             WE       : in std_logic;
             Q : out std_logic_vector(7 downto 0);
             Inclock  : in std_logic;
             Outclock : in std_logic
     );

    -- pragma translate_off
    function int_to_str( value : integer ) return string is
    variable ivalue,index : integer;
    variable digit : integer;
    variable line_no: string(8 downto 1) := "        ";
    begin
    ivalue := value;
    index := 1;
    while (ivalue > 0 ) loop
       digit := ivalue MOD 10;
       ivalue := ivalue/10;
       case digit is
           when 0 =>
              line_no(index) := '0';
           when 1 =>
              line_no(index) := '1';
           when 2 =>
              line_no(index) := '2';
           when 3 =>
              line_no(index) := '3';
           when 4 =>
              line_no(index) := '4';
           when 5 =>
              line_no(index) := '5';
           when 6 =>
              line_no(index) := '6';
           when 7 =>
              line_no(index) := '7';
           when 8 =>
              line_no(index) := '8';
           when 9 =>
              line_no(index) := '9';
           when others =>
              ASSERT FALSE
              REPORT "Illegal Number!"
              SEVERITY ERROR;
       end case;
       index := index + 1;
    end loop;
    return line_no;
 end;

    function hex_str_to_int( str : string ) return integer is
    variable len : integer := str'length;
    variable ivalue : integer := 0;
    variable digit : integer;
    begin
    for i in len downto 1 loop
       case str(i) is
          when '0' =>
		digit := 0;
          when '1' =>
             digit := 1;
          when '2' =>
             digit := 2;
          when '3' =>
             digit := 3;
          when '4' =>
             digit := 4;
          when '5' =>
             digit := 5;
          when '6' =>
             digit := 6;
          when '7' =>
             digit := 7;
          when '8' =>
             digit := 8;
          when '9' =>
             digit := 9;
          when 'A' =>
             digit := 10;
          when 'a' =>
             digit := 10;
          when 'B' =>
             digit := 11;
          when 'b' =>
             digit := 11;
          when 'C' =>
             digit := 12;
          when 'c' =>
             digit := 12;
          when 'D' =>
             digit := 13;
          when 'd' =>
             digit := 13;
          when 'E' =>
             digit := 14;
          when 'e' =>
             digit := 14;
          when 'F' =>
             digit := 15;
          when 'f' =>
             digit := 15;
          when others =>
           ASSERT FALSE
           REPORT "Illegal Character "&  str(i) & "in Intel Hex File! "
           SEVERITY ERROR;
   end case;
   ivalue := ivalue * 16 + digit;
   end loop;
   return ivalue;
 end;

   procedure Shrink_line(L : inout LINE; pos : in integer)
   is
	subtype nstring is string(1 to pos);
	variable stmp : nstring;
   begin
       if pos >= 1 then
           read(l,stmp);
       end if;
   end;
   -- pragma translate_on
end syn_ram_256x8_iror;

architecture behavior of syn_ram_256x8_iror is
   constant Width : integer := 8;
   constant WidthAd : integer := 8;
   constant NumWords   : integer := 256;
   signal qstate : std_logic_vector(Width - 1 downto 0);
begin

   -- pragma translate_off
   RAM_Process: process(Outclock, Inclock)
   TYPE t_mem_data IS ARRAY(0 to NumWords - 1) of std_logic_vector(Width - 1 downto 0);
   variable mem_data: t_mem_data;
   variable address_int, mem_data_tmp: integer;
   variable mem_init: boolean := false;
   variable i,j,k,lineno: integer := 0;
   variable buf: line ;
   variable booval: boolean ;
   FILE mem_data_file: TEXT IS IN LPM_FILE;
   variable base, byte, rec_type, datain, addr, checksum: string(2 downto 1);
   variable startadd: string(4 downto 1);
   variable ibase: integer := 0;
   variable ibyte: integer := 0;
   variable istartadd: integer := 0;
   variable check_sum_vec, check_sum_vec_tmp: std_logic_vector(7 downto 0);
   begin

    if NOT(mem_init) then
       -- Initialize to 0
       for i in mem_data'LOW to mem_data'HIGH loop
          mem_data(i) := (OTHERS => '0');
       end loop;

       if (LPM_FILE = "UNUSED") then
              ASSERT FALSE
              REPORT "Initialization File Not Found !"
              SEVERITY WARNING;
       else
         WHILE NOT ENDFILE(mem_data_file) loop
            booval := true;
            READLINE(mem_data_file, buf);
            lineno := lineno + 1;
            check_sum_vec := (OTHERS => '0');
            if (buf(buf'LOW) = ':') then
               i := 1;
               shrink_line(buf, i);
               READ(L=>buf, VALUE=>byte, good=>booval);
               if not (booval) then
                  ASSERT FALSE
                  REPORT "[Line "& int_to_str(lineno) & "]:Illegal Intel Hex Format!"
                  SEVERITY ERROR;
               end if;
               ibyte := hex_str_to_int(byte);
               check_sum_vec := unsigned(check_sum_vec) + unsigned(CONV_STD_LOGIC_VECTOR(ibyte, 8));
               READ(L=>buf, VALUE=>startadd, good=>booval);
               if not (booval) then
                  ASSERT FALSE
                  REPORT "[Line "& int_to_str(lineno) & "]:Illegal Intel Hex Format! "
                  SEVERITY ERROR;
               end if;
               istartadd := hex_str_to_int(startadd);
               addr(2) := startadd(4);
               addr(1) := startadd(3);
               check_sum_vec := unsigned(check_sum_vec) + unsigned(CONV_STD_LOGIC_VECTOR(hex_str_to_int(addr), 8));
               addr(2) := startadd(2);
               addr(1) := startadd(1);
               check_sum_vec := unsigned(check_sum_vec) + unsigned(CONV_STD_LOGIC_VECTOR(hex_str_to_int(addr), 8));
               READ(L=>buf, VALUE=>rec_type, good=>booval);
               if not (booval) then
                  ASSERT FALSE
                  REPORT "[Line "& int_to_str(lineno) & "]:Illegal Intel Hex Format! "
                  SEVERITY ERROR;
               end if;
               check_sum_vec := unsigned(check_sum_vec) + unsigned(CONV_STD_LOGIC_VECTOR(hex_str_to_int(rec_type), 8));
            else
               ASSERT FALSE
               REPORT "[Line "& int_to_str(lineno) & "]:Illegal Intel Hex Format! "
               SEVERITY ERROR;
            end if;
            case rec_type is
               when "00"=>
                  i := 0;
                  k := 0;
                  while( i < ibyte ) loop
                     mem_data_tmp := 0;
                     for j in 0 to 0 loop
                        READ(L=>buf, VALUE=>datain,good=>booval);
                        if not (booval) then
                           ASSERT FALSE
                           REPORT "[Line "& int_to_str(lineno) & "]:Illegal Intel Hex Format! "
                           SEVERITY ERROR;
                        end if;
                        check_sum_vec := unsigned(check_sum_vec) + unsigned(CONV_STD_LOGIC_VECTOR(hex_str_to_int(datain), 8));
                        mem_data_tmp := mem_data_tmp * 256 + hex_str_to_int(datain);
                        i := i + 1;
                        if (i = ibyte) then
                           exit;
                        end if;
                     end loop;

                     mem_data(ibase + istartadd + k) := CONV_STD_LOGIC_VECTOR(mem_data_tmp, Width);

                     k := k + 1;
                  end loop;
               when "01"=>
                  exit;
               when "02"=>
                  ibase := 0;
                  if (ibyte /= 2) then
                           ASSERT FALSE
                           REPORT "[Line "& int_to_str(lineno) & "]:Illegal Intel Hex Format for record type 02! "
                           SEVERITY ERROR;
                  end if;
                  for i in 0 to (ibyte-1) loop
                     READ(L=>buf, VALUE=>base,good=>booval);
                     ibase := ibase * 256 + hex_str_to_int(base);
                     if not (booval) then
                        ASSERT FALSE
                        REPORT "[Line "& int_to_str(lineno) & "]:Illegal Intel Hex Format! "
                        SEVERITY ERROR;
                     end if;
                     check_sum_vec := unsigned(check_sum_vec) + unsigned(CONV_STD_LOGIC_VECTOR(hex_str_to_int(base), 8));
                  end loop;
                  ibase := ibase * 16;
               when OTHERS =>
                  ASSERT FALSE
                  REPORT "[Line "& int_to_str(lineno) & "]:Illegal record type in Intel Hex File! "
                  SEVERITY ERROR;
            end case;
            READ(L=>buf, VALUE=>checksum,good=>booval);
            if not (booval) then
               ASSERT FALSE
               REPORT "[Line "& int_to_str(lineno) & "]:Checksum is missing! "
               SEVERITY ERROR;
            end if;

            check_sum_vec := unsigned(not (check_sum_vec)) + 1 ;
            check_sum_vec_tmp := CONV_STD_LOGIC_VECTOR(hex_str_to_int(checksum),8);

            if (check_sum_vec /= check_sum_vec_tmp) then
               ASSERT FALSE
               REPORT "[Line "& int_to_str(lineno) & "]:Incorrect Checksum!"
               SEVERITY ERROR;
            end if;
         end loop;
       end if;
       mem_init := TRUE;
    end if;

   if (Inclock'event and (Inclock = '1') and (Inclock'last_value = '0')) then
      address_int := CONV_INTEGER(unsigned(Address));
      if (WE = '1') then
          mem_data(address_int) :=  Data;
      end if;
   end if;

   if (Outclock'event and (Outclock = '1') and (Outclock'last_value = '0')) then
      qstate <=  mem_data(address_int);
   end if;

   end process RAM_Process;

   Q <= qstate;

   -- pragma translate_on
end behavior;

-- pragma translate_off
configuration cfg_syn_ram_256x8_iror of syn_ram_256x8_iror is
	for behavior
	end for;
end cfg_syn_ram_256x8_iror;
-- pragma translate_on
